//package com.live.server.controller;
//
//import com.live.common.domain.ResponseData;
//import com.live.common.domain.request.CommonStringId;
//import com.live.common.domain.request.CreateRoomRequest;
//import com.live.common.service.CategoryService;
//import com.live.common.service.LiveService;
//import io.swagger.annotations.*;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.web.bind.annotation.*;
//import javax.annotation.Resource;
//import javax.servlet.http.HttpServletRequest;
//
//@CrossOrigin
//@RestController
//@RequestMapping("/anchor")
//@Api(tags = "主播接口接口")
//public class UserLiveController {
//
//    @Resource
//    private CategoryService categoryService;
//    @Resource
//    private LiveService liveService;
//
//    @PostMapping(value = "/getMatchType")
//    @ApiOperation(value = "获取直播类别")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> getMatchType(HttpServletRequest request) {
//        return categoryService.getLiveTitleTab();
//    }
//
//    @PostMapping(value = "/getMatchListByType")
//    @ApiOperation(value = "根据直播类型获取赛事列表")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> getMatchListByType(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
//        return liveService.getMatchListByType(commonStringId, request);
//    }
//
//    @PostMapping(value = "/getRoomInfoByUser")
//    @ApiOperation(value = "根据Token获取房间信息")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> getRoomInfoByUser(HttpServletRequest request) {
//        return liveService.getRoomInfoByUser(request);
//    }
//
//    @PostMapping(value = "/createOrEditRoom")
//    @ApiOperation(value = "创建 / 修改 房间【创建 roomId (null 或者 '')】")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> createOrEditRoom(@RequestBody CreateRoomRequest roomRequest, HttpServletRequest request) {
//        if(StringUtils.isBlank(roomRequest.getRoomId())){
//            return liveService.createRoom(roomRequest, request);
//        } else {
//            return liveService.editRoom(roomRequest, request);
//        }
//    }
//
//    @PostMapping(value = "/createPushUrl")
//    @ApiOperation(value = "生成腾讯云推流地址")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> createTxPushUrl(HttpServletRequest request) {
//        return liveService.createPushUrl(request);
//    }
//
//    @PostMapping(value = "/createAliPushUrl")
//    @ApiOperation(value = "生成阿里云推流地址")
//    @ApiImplicitParams({
//            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
//    })
//    public ResponseData<?> createAliPushUrl(HttpServletRequest request) {
//        return liveService.createAliPushUrl(request);
//    }
//
////    @PostMapping(value = "/createPlayUrl")
////    @ApiOperation(value = "生成播放地址")
////    @ApiImplicitParams({
////            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
////    })
////    public ResponseData<?> createPlayUrl(HttpServletRequest request) {
////        return liveService.createPlayUrl(request);
////    }
//
//}