package com.live.common.domain.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

@Data
public class RegisterRequest {

    @NotBlank(message = "请输入手机号")
    @Size(max = 11, min = 11, message = "请输入11位手机号")
    @ApiModelProperty(value = "手机号")
    private String phone;

    @NotBlank(message = "请输入短信验证码")
    @ApiModelProperty(value = "短信验证码")
    private String smsCode;

//    @Size(max = 15, min = 6, message = "请输入6-15位登录密码")
//    @ApiModelProperty(value = "登录密码")
//    private String password;

//    @ApiModelProperty(value = "渠道ID")
//    private Integer channelId;

//    @ApiModelProperty(value = "用户昵称")
//    private String nickName;

//    @ApiModelProperty(value = "用户头像地址 可 null")
//    private String userAvatar;

}
