package com.live.common.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SignUtils {

    /**
     * 获取参数签名
     * @param paramMap  签名参数
     * @param key 平台秘钥
     * @return
     */
    public static String getSign(Map<String , String> paramMap , String key){
        SortedMap<String, String> smap = new TreeMap<String, String>(paramMap);
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> m : smap.entrySet()) {
            Object value = m.getValue();
            if (!"sign".equals(m.getKey())&&value != null && StringUtils.isNotBlank(String.valueOf(value))){
                stringBuffer.append(m.getKey()).append("=").append(m.getValue()).append("&");
            }
        }
        stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        String argPreSign = stringBuffer.append(key).toString();
        
        String signStr = SecurityUtil.crtyMd5(argPreSign).toUpperCase();
        return signStr;
    }
    
    public static void main(String[] argv){
        String msg = "memberid=17&money=28.00&notifyurl=http://129.226.169.250:8033/capi/notify/notify/5&orderid=20200710144235pYhMPH41d39076ac27730bbe47dd10f342f631";
        System.out.println(SecurityUtil.crtyMd5(msg));
    }
    
    public static final String sign(String sign){
        return SecurityUtil.crtyMd5(sign).toUpperCase();
    }

    /**
     * 获取参数拼接串
     * @param paramMap
     * @return
     */
    public static String getParamStr(Map<String , String> paramMap){
        SortedMap<String, Object> smap = new TreeMap<String, Object>(paramMap);
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, Object> m : smap.entrySet()) {
            Object value = m.getValue();
            if (value != null && StringUtils.isNotBlank(String.valueOf(value))){
                stringBuffer.append(m.getKey()).append("=").append(value).append("&");
            }
        }
        stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
        return stringBuffer.toString();
    }


    /**
     * 验证签名
     * @param paramMap  签名参数
     * @param key 私钥
     * @param signStr   原始签名密文[从sign字段获取]
     * @return
     */
    public static boolean checkSign(Map<String , String> paramMap , String key , String signStr){
        if (StringUtils.isBlank(signStr)){
            return false;
        }
        String sign = getSign(paramMap, key);
        if(signStr.equals(sign)){
            return true;
        }else{
            return false;
        }
    }


    /**
     * 验证签名
     * @param paramMap  签名参数
     * @param key 签名私钥
     * @return
     */
    public static boolean checkSign(Map<String , String> paramMap , String key){
        String signStr = paramMap.get("sign");
        if (StringUtils.isBlank(signStr)){
            return false;
        }
        String sign = getSign(paramMap, key);
        if(signStr.equals(sign)){
            return true;
        }else{
            return false;
        }
    }

}
