package com.live.console.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.dto.back.SysMenuDTO;
import com.live.common.service.ISysMenuService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;


@CrossOrigin
@RestController
@RequestMapping("/sys/menu")
public class SysMenuController {

    @Resource
    private ISysMenuService iSysMenuService;

    @PostMapping
    @ApiOperation("新增菜单栏")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> save(@RequestBody SysMenuDTO sysMenu){
        return iSysMenuService.save(sysMenu);
    }

    @PostMapping("updateMenu")
    @ApiOperation("修改菜单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> update(@RequestBody SysMenuDTO sysMenuDTO){
        return iSysMenuService.update(sysMenuDTO);
    }

    @PostMapping("list")
    @ApiOperation("菜单列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> getSysMenuDTOS(){
        return iSysMenuService.getSysMenuList();
    }

}
