package com.live.server.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.live.common.constant.ConstantValue;
import com.live.common.domain.ResponseData;
import com.live.common.domain.entity.DownloadAddress;
import com.live.common.mapper.DownAddressMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@CrossOrigin
@RestController
@RequestMapping("/download")
@Api(tags = "安装包下载文档")
public class DownloadController {

    @Resource
    private DownAddressMapper downAddressMapper;

    @GetMapping(value = "/getDownAddress")
    @ApiOperation(value = "获取 ios 安卓 安装包下载地址")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getDownAddress(HttpServletRequest request) {
        List<DownloadAddress> iosDownList = downAddressMapper.selectList(Wrappers.<DownloadAddress>lambdaQuery()
                .in(DownloadAddress::getDevice, 2)
                .eq(DownloadAddress::getDeleted, 0)
                .orderByDesc(DownloadAddress::getCreateTime)
        );
        List<DownloadAddress> androidDownList = downAddressMapper.selectList(Wrappers.<DownloadAddress>lambdaQuery()
                .in(DownloadAddress::getDevice, 1)
                .eq(DownloadAddress::getDeleted, 0)
                .orderByDesc(DownloadAddress::getCreateTime)
        );

        Map<String, String> downMap = new HashMap<>();
        downMap.put("ios", null);
        downMap.put("android", null);
        if(iosDownList.size() > 0){
            downMap.put("ios", ConstantValue.AVATAR_URL + iosDownList.get(0).getAdress());
        }
        if(androidDownList.size() > 0){
            downMap.put("android", ConstantValue.AVATAR_URL + androidDownList.get(0).getAdress());
        }
        return ResponseData.successResponse(downMap);
    }

}
