package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatBasketballTeamPlayerDto {

    private String state;
    private List<BasketballTeamsPlayerDto> players;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class BasketballTeamsPlayerDto {
        private Integer id;
        private String name;
        private String nameEn;
        //性别（male: 男, female：女）
        private String gender;
        private Integer areaId;
        private String birthday;
        private Integer birthAreaId;
        private String rnNumber;
        private String height;
        private String weight;
        private String position;

//“id”: 37,						//球员Id
//                “name”: “戈登·海沃德”,			//球员名称
//                “nameEn”: “Gordon Hayward”,		//球员英文名
//                “areaId”: 193,					//国籍
//                “birthday”: “1990-03-23”,		//出生日期
//                “birthAreaId”: 193,				//出生地
//                “rnNumber”: “20”,				//球衣号码
//                “gender”: “male”,				//性别（male: 男, female：女）
//                “height”: “2.03m”,				//身高
//                “weight”: “102”,				//体重
//                “position”: “Small Forward”		//位置
    }

}
