package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatFootballScheduleMatchDto {

    private String state;
    private List<AlStatScheduleFootballInfoDto> matchs;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatScheduleFootballInfoDto {
        private Integer id;
        private Integer competitionId;
        private String competitionName;
        private String season;
        private String stage;
        private String startTime;
        private Integer homeTeamId;
        private String homeTeamName;
        private Integer awayTeamId;
        private String awayTeamName;
        //比赛状态（0:未开始, 1:进行中, 2:已结束, 3:延期, 4:中断, 5:取消）
        private Integer status;
        private String halfTimeScore;
        private String fullTimeScore;
        private String extraTimeScore;
        private String penalScore;
        private String finalScore;
        private Integer winTeamId;
        private Integer manId;
    }

//			“id”: 10001,					//比赛Id
//            “competitionId”: 1,				//赛事Id
//            “competitionName”: “英超”,		//赛事名称
//            “season”: “18/19”,				//赛季
//            “stage”: “第5轮”,				//比赛轮次
//            “startTime”: “2019-01-10 01:30:00”,	//比赛开始时间
//            “homeTeamId”: 13,				//主队Id
//            “homeTeamName”: “利物浦”,		//主队名称
//            “awayTeamId”: 12,				//客队Id
//            “awayTeamName”: “阿森纳”,		//客队名称
//            “status”: 0,					//比赛状态（0:未开始, 1:进行中, 2:已结束, 3:延期, 4:中断, 5:取消）
//            “halfTimeScore”: “0 : 0”,		//半场比分
//            “fullTimeScore”: “1 : 0”,		//常规时间比分
//            “extraTimeScore”: “”,			//加时赛比分（为空表示没有加时赛）
//            “penalScore”: “”,				//点球大战比分（为空表示没有点球大战）
//            “finalScore”: “1 : 0”,			//最终比分（出现点球大战的比赛会以*标注获胜球队，例如*1 : 1或者1 : 1*）
//            “winTeamId”: 13,				//获胜球队Id
//            “manId”: 25						//最佳球员Id

}
