package com.live.common.domain.dto.back;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserDTO implements Serializable {

    private Integer id;

    @ApiModelProperty("用户名")
    private String username;

    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("角色id")
    private Integer roleId;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty("头像")
    private String avatar;

    @ApiModelProperty("是否禁用")
    private Integer deleted;

  /*  @ApiModelProperty("上次登录时间")
    private Date lastUpdate;*/
   @ApiModelProperty("渠道")
   private String channel;

    @ApiModelProperty("多渠道对")
    private Map<Integer,String> channelMap;

}
