package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AlStatPlayerBasketballStatisticsDto {

    private String state;
    private List<AlStatScheduleMatchInfoDto> matchs;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatScheduleMatchInfoDto {
        private List<AlStatStatsInfoDto> stats;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class AlStatStatsInfoDto {
        private Integer id;
        private Integer teamId;
        private String teamName;
        //球员Id
        private Integer playerId;
        //球员名称
        private String playerName;
        //球衣号码
        private Integer rnNumber;
        //场上位置
        private String position;
        //主队或客队（home:主队,away:客队）
        private String homeAway;
        //是否首发 1
        private Integer isFirstFive;
        //是否上场 1
        private Integer isAppear;
        //上场时间（分钟数）
        private Integer minsPlayed;
        //上场时间（秒数）
        private Integer secsplayed;
        //得分
        private Integer points;
        //助攻
        private Integer assists;
        //篮板
        private Integer rebounds;
        //进攻篮板
        private Integer offRebounds;
        //防守篮板
        private Integer defRebounds;
        //抢断
        private Integer steals;
        //失误
        private Integer turnovers;
        //盖帽
        private Integer blocks;
        //被盖帽
        private Integer blocksAga;
        //犯规
        private Integer fouls;
        //被犯规
        private Integer fouled;
        //投篮出手
        private Integer fieldGoalsAtt;
        //投篮命中
        private Integer fieldGoalsMade;
        //投篮命中率
        private Integer fieldGoalsPerc;
        //两分球出手
        private Integer twoPointsAtt;
        //两分球命中
        private Integer twoPointsMade;
        //两分球命中率
        private Integer twoPointsPerc;
        //三分球出手
        private Integer threePointsAtt;
        //三分球命中
        private Integer threePointsMade;
        //三分球命中率
        private Integer threePointsPerc;
        //罚篮出手
        private Integer freeThrowsAtt;
        //罚篮命中
        private Integer freeThrowsMade;
        //罚篮命中率
        private Integer freeThrowsPerc;
        //正负值
        private Integer plusminus;
    }


//    “state”: “success”,			//请求状态，success为成功，error为失败
//            “errorCode”: “10001”,		//错误码（当state为error时返回此属性，否则不返回）
//            “errorMsg”: “请求地址错误”,	//错误信息（当state为error时返回此属性，否则不返回）
//            “matchs”: [					//比赛集合
//    {
//			“id”: 23,					//比赛Id
//			“seasonId”: 10,				//赛季Id
//			“competitionId”: 1,			//赛事Id
//			“season”: “19/20”,			//赛季
//			“startTime”: “2020-06-10 10:30:00”,	//比赛开始时间
//			“homeTeamId”: 1,			//主队Id
//			“homeTeamName”: “湖人”,		//主队名称
//			“awayTeamId”: 6,			//客队Id
//			“awayTeamName”: “火箭”,		//客队名称
//			“status”: 0,				//比赛状态（0:未开始, 1:进行中, 2:已结束, 3:延期, 4:中断, 5:取消）
//			“homeScore”: 121,			//主队得分
//			“awayScore”: 128,			//客队得分
//			“winTeamId”: 6,				//获胜球队Id
//			“stats”: [					//球员数据集合
//        {
//					“id”: 10001,				//数据Id
//					“teamId”: 6,				//球队Id
//					“teamName”: “火箭”,			//球队名称
//					“playerId”: 87,				//球员Id
//					“playerName”: “詹姆斯·哈登”,		//球员名称
//					“rnNumber”: 13,				//球衣号码
//					“position”: “Shooting Guard”,	//场上位置
//					“homeAway”: “home”,			//主队或客队（home:主队,away:客队）
//					“isFirstFive”: 1,			//是否首发
//					“isAppear”: 1,				//是否上场
//					“minsPlayed”: 38,			//上场时间（分钟数）
//					“secsplayed”: 40,			//上场时间（秒数）
//					“points”: 41,				//得分
//					“assists”: 8,				//助攻
//					“rebounds”: 6,				//篮板
//					“offRebounds”: 2,			//进攻篮板
//					“defRebounds”: 4,			//防守篮板
//					“steals”: 3,				//抢断
//					“turnovers”: 5,				//失误
//					“blocks”: 0,				//盖帽
//					“blocksAga”: 3,				//被盖帽
//					“fouls”: 2,					//犯规
//					“fouled”: 6,				//被犯规
//					“fieldGoalsAtt”: 20,		//投篮出手
//					“fieldGoalsMade”: 12,		//投篮命中
//					“fieldGoalsPerc”: 0.6,		//投篮命中率
//					“twoPointsAtt”: 8,			//两分球出手
//					“twoPointsMade”: 4,			//两分球命中
//					“twoPointsPerc”: 0.5,		//两分球命中率
//					“threePointsAtt”: 12,		//三分球出手
//					“threePointsMade”: 8,		//三分球命中
//					“threePointsPerc”: 0.67,	//三分球命中率
//					“freeThrowsAtt”: 9,			//罚篮出手
//					“freeThrowsMade”: 9,		//罚篮命中
//					“freeThrowsPerc”: 1,		//罚篮命中率
//					“plusminus”: 11				//正负值
//        },

}
