package com.live.common.domain.dto.api;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GetHotRankInfoByIdResponse {

    private Integer id;
    private String anchorId;
    private String anchorName;
    private String anchorIcon;
    private String anchorDesc;
    //中
    private Integer wins;
    //总
    private Integer sum;
    //连中
    private Integer continuousWin;
    //发布时间
    private String releaseTime;
    private String content;
    private String title;
    //赢 红色 输 黑色
    private boolean winOrLose;
    //主播下注位 0 主胜 1 平 2 客胜
    private Integer betPosition;
    //赢家位置 -1 比赛未结束 0 主胜 1 平 2 客胜
    private Integer winPosition;
    //近期战绩
    private List<String> recentRecord;
    private String teamVs;
    //团队赔率
    private TeamIndex matchOdds;
    //团队赔率
    private MatchList teamInfo;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class MatchList{
        private MatchListInfo home;
        private MatchListInfo away;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TeamIndex {
        //主胜
        private Double wins;
        //平
        private Double draw;
        //客胜
        private Double lose;
    }
}
