package com.live.common.exception;

import com.alibaba.fastjson.JSONException;
import com.live.common.domain.ResponseData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

import java.util.List;

@Slf4j
@RestControllerAdvice
public class GlobalExceptionHandler {

    @ExceptionHandler(value = Exception.class)
    public ResponseData<?> exceptionHandler(Exception e) {
        e.printStackTrace();
        return ResponseData.failResponse();
    }

    @ExceptionHandler(MaxUploadSizeExceededException.class)
    public ResponseData<?> handlerMaxUploadFile(MaxUploadSizeExceededException ex) {
        return ResponseData.fail400Response("文件上传大小不能超过 5 MB，请压缩图片或者降低图片质量再上传!");
    }

    @ExceptionHandler(IllegalStateException.class)
    public ResponseData<?> handlerMaxUploadFile(IllegalStateException ex) {
        return ResponseData.fail400Response("文件上传大小不能超过 5 MB，请压缩图片或者降低图片质量再上传!");
    }

    @ExceptionHandler(MissingServletRequestParameterException.class)
    public ResponseData<?> paramExceptionHandler(Exception e) {
        log.error(e.getMessage());
        return ResponseData.fail400Response("请上传完整参数");
    }

    @ExceptionHandler(HttpMessageNotReadableException.class)
    public ResponseData<?> paramFmtExceptionHandler(Exception e) {
        log.error(e.getMessage());
        return ResponseData.fail400Response("上传参数格式错误");
    }

    @ExceptionHandler(MethodArgumentNotValidException.class)
    public ResponseData<?> methodArgumentNotValidException(MethodArgumentNotValidException ex) {
        BindingResult result = ex.getBindingResult();
        List<FieldError> fieldErrors = result.getFieldErrors();
        StringBuilder sb = new StringBuilder();
        for (org.springframework.validation.FieldError fieldError: fieldErrors) {
            sb.append(fieldError.getDefaultMessage());
        }
        return ResponseData.fail400Response(sb.toString());
    }

    @ExceptionHandler(HttpRequestMethodNotSupportedException.class)
    public ResponseData<?> requestExceptionHandler(Exception e) {
        log.error(e.getMessage());
        return ResponseData.fail400Response("请求Type错误");
    }

    @ExceptionHandler(JSONException.class)
    public ResponseData<?> jsonExceptionHandler(Exception e) {
        log.error(e.getMessage());
        return ResponseData.fail400Response("JSON格式错误,导致转换异常");
    }

    @ExceptionHandler(DuplicateKeyException.class)
    public ResponseData<?> duplicateKeyExceptionHandler(DuplicateKeyException e) {
        log.error(e.getMessage());
        return ResponseData.fail400Response("key 重复");
    }


    @ExceptionHandler(CommonException.class)
    public ResponseData<?> commonExceptionHandler(Exception e) {
        log.error(e.getMessage());
        return ResponseData.fail500Response(e.getMessage());
    }

}