//package com.live.server.controller;
//
//import com.alibaba.fastjson.JSONArray;
//import com.alibaba.fastjson.JSONObject;
//import com.baomidou.mybatisplus.core.toolkit.Wrappers;
//import com.live.common.domain.ResponseData;
//import com.live.common.domain.entity.Category;
//import com.live.common.domain.entity.Room;
//import com.live.common.domain.request.LiveCutImgNotifyDto;
//import com.live.common.enums.StatusEnum;
//import com.live.common.mapper.RoomMapper;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiResponse;
//import io.swagger.annotations.ApiResponses;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.web.bind.annotation.*;
//
//import javax.annotation.Resource;
//import javax.servlet.http.HttpServletRequest;
//import java.io.BufferedReader;
//import java.io.IOException;
//import java.io.InputStreamReader;
//import java.nio.charset.StandardCharsets;
//import java.util.Base64;
//import java.util.List;
//
//@Slf4j
//@CrossOrigin
//@RestController
//@RequestMapping("/platform")
//@Api(tags = "第三方回调接口")
//public class PlatformController {
//
//    @Resource
//    private RoomMapper roomMapper;
//
//
//    @PostMapping(value = "/liveCutImgNotify")
//    @ApiResponses({
//            @ApiResponse(code = 200, message = "成功处理请求"),
//            @ApiResponse(code = 401, message = "没有权限访问该服务"),
//            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
//            @ApiResponse(code = 404, message = "未发现该服务"),
//            @ApiResponse(code = 500, message = "服务器内部错误")
//    })
//    public ResponseData<?> liveCutImgNotify(HttpServletRequest request) throws IOException {
//        BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream()));
//        String str = "";
//        StringBuilder wholeStr = new StringBuilder();
//        //一行一行的读取body体里面的内容；
//        while ((str = reader.readLine()) != null) {
//            wholeStr.append(str);
//        }
//        String jsonString = new String(Base64.getDecoder().decode(wholeStr.toString()), StandardCharsets.UTF_8);
//
//        LiveCutImgNotifyDto cutImgNotifyDto = JSONArray.parseObject(jsonString, LiveCutImgNotifyDto.class);
//        if (cutImgNotifyDto.getItems() == null) {
//            return ResponseData.successResponse();
//        } else {
//            List<Room> roomList = roomMapper.selectList(Wrappers.<Room>lambdaQuery()
//                    .eq(Room::getDeleted, StatusEnum.ENABLE.getCode())
//                    .eq(Room::getType, 1)
//                    .like(Room::getLiveUrl, cutImgNotifyDto.getItems().get(0).getChannelname())
//            );
//
//            for (Room room : roomList) {
//                String cutImg = cutImgNotifyDto.getItems().get(0).getUrls().get(0);
//                if(!cutImg.equals(room.getRoomCover())){
//                    room.setRoomCover(cutImgNotifyDto.getItems().get(0).getUrls().get(0));
//                    roomMapper.updateById(room);
//                    log.info("修改房间封面图成功:{}", room.getHuanXinRoomId());
//                }
//            }
//        }
//        return ResponseData.successResponse();
//    }
//
//}
