package com.live.console.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.live.common.constant.ConstantValue;
import com.live.common.domain.ResponseData;
import com.live.common.domain.ResultPage;
import com.live.common.domain.entity.DownloadAddress;
import com.live.common.domain.request.back.DownloadAddressDTO;
import com.live.common.domain.request.back.GetDownloadListRequest;
import com.live.common.enums.StatusEnum;
import com.live.common.mapper.DownAddressMapper;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@CrossOrigin
@RestController
@RequestMapping("/download")
public class DownloadAddressController {

    @Resource
    private DownAddressMapper downAddressMapper;

    //todo 新增
    @PostMapping("/save")
    @ApiOperation("新增")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> save(@RequestBody DownloadAddressDTO downloadAddressDTO) {
        if (ObjectUtils.isNotNull(downloadAddressDTO.getChannelMap())) {
            Set<Map.Entry<Integer, String>> entries = downloadAddressDTO.getChannelMap().entrySet();
            for (Map.Entry<Integer, String> entry : entries) {
                DownloadAddress downloadAddress = downloadAddressConvert(downloadAddressDTO);
                downloadAddress.setChannelName(entry.getKey() == 0 ? "官方推广" : "推广" + entry.getKey().toString() + "组");
                downloadAddress.setShareAdress(ConstantValue.completeAddress(downloadAddress.getAdress()));
                downloadAddress.setChannel(entry.getKey().toString());
                DownloadAddress download = downAddressMapper.findDowloadAdress(downloadAddressDTO.getAdress(), entry.getKey().toString());
                if (ObjectUtils.isNotNull(download)) {
                    return ResponseData.fail400Response(entry.getKey() == 0 ? "官方渠道已存在相同资源地址，请对资源的内容做修改或删掉重新建立相同名称下载包" : "渠道" + entry.getKey() + "已存在相同资源地址，请对资源的内容做修改或删掉资源重新建立相同名称下载包");
                }
                downAddressMapper.insert(downloadAddress);
            }
            return ResponseData.successResponse();
        }
        return ResponseData.fail500Response("格式不正确");
    }

    //todo 修改
    @PostMapping("updateDownLoad")
    @ApiOperation("更新下载内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData update(@RequestBody DownloadAddressDTO downloadAddressDTO) {
        DownloadAddress downloadAddress = downloadAddressConvert(downloadAddressDTO);
        List<DownloadAddress> downloadAddressList = new ArrayList<>();
        if (ObjectUtils.isNotNull(downloadAddressDTO.getChannelMap())) {
            //处理批量删除单条操作
            Set<Map.Entry<Integer, String>> entries = downloadAddressDTO.getChannelMap().entrySet();
            for (Map.Entry<Integer, String> entry : entries) {
                DownloadAddress download = downAddressMapper.findDowloadAdress(downloadAddressDTO.getAdress(), entry.getKey().toString());
                if (download != null) {
                    //做更新
                    //删除操作
                    if (downloadAddressDTO.getDeleted() == 1) {
                        DownloadAddress updated = new DownloadAddress();
                        updated.setId(download.getId());
                        updated.setDeleted(1);
                        downloadAddressList.add(updated);
                    }

                    //更新操作
                    if (downloadAddressDTO.getDeleted() == 0) {
                        //做更新
                        download.setDevice(downloadAddressDTO.getDevice());
                        download.setVersion(downloadAddressDTO.getVersion());
                        download.setIsForce(downloadAddressDTO.getIsForce());
                        download.setChannelName(entry.getKey() == 0 ? "官方推广" : "推广" + entry.getKey().toString() + "组");
                        download.setChannel(entry.getKey().toString());//推广码
                        download.setDescr(downloadAddressDTO.getDescr());
                        download.setShareAdress(ConstantValue.completeAddress(downloadAddress.getAdress()));
                        download.setAdress(downloadAddressDTO.getAdress());
                        download.setUpdateTime(new Date());
                        downloadAddressList.add(download);
                    }

                }

                if (ObjectUtils.isNull(download)) {
                    DownloadAddress dowloadAdd = new DownloadAddress();
                    dowloadAdd.setDevice(downloadAddressDTO.getDevice());
                    dowloadAdd.setVersion(downloadAddressDTO.getVersion());
                    dowloadAdd.setIsForce(downloadAddressDTO.getIsForce());
                    dowloadAdd.setChannelName(entry.getKey() == 0 ? "官方推广" : "推广" + entry.getKey().toString() + "组");
                    dowloadAdd.setChannel(entry.getKey().toString());//推广码
                    dowloadAdd.setDescr(downloadAddressDTO.getDescr());
                    dowloadAdd.setShareAdress(ConstantValue.completeAddress(downloadAddress.getAdress()));
                    dowloadAdd.setAdress(downloadAddressDTO.getAdress());
                    //download.setUpdateTime(new Date());
                    //downloadAddressList.add(download);
                    downAddressMapper.insert(dowloadAdd);
                }

            }
        }
        for(DownloadAddress address : downloadAddressList){
            downAddressMapper.updateById(address);
        }
        return ResponseData.successResponse();
    }


    //todo 详情
    @PostMapping("detail")
    @ApiOperation("获取下载内容详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> findDownloadAddress(@RequestParam Integer downloadId) {
        DownloadAddress result = downAddressMapper.selectById(downloadId);
        return ResponseData.successResponse(downloadAddressConvert(result));
    }


    //todo 列表
    @PostMapping("list")
    @ApiOperation("获取下载内容列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> findDownloadAddress(@RequestBody GetDownloadListRequest downloadListRequest) {
        int jumpNum = (downloadListRequest.getPageNum() - 1) * downloadListRequest.getPageSize();
        QueryWrapper<DownloadAddress> queryWrapper = new QueryWrapper<DownloadAddress>();
        queryWrapper.eq("deleted", StatusEnum.ENABLE.getCode());

        if(StringUtils.isNotBlank(downloadListRequest.getChannel())){
            queryWrapper.like("channel", downloadListRequest.getChannel());
        }

        queryWrapper.orderByDesc("create_time");
        long count = downAddressMapper.selectCount(queryWrapper);
        queryWrapper.last(String.format(" limit %s,%s", jumpNum, downloadListRequest.getPageSize()));

        List<DownloadAddress> downloadAddresses = downAddressMapper.selectList(queryWrapper);
        List<DownloadAddressDTO> result = downloadAddresses.stream().map(this::downloadAddressConvert).collect(Collectors.toList());
        return ResponseData.successResponse(new ResultPage(downloadListRequest.getPageNum(), downloadListRequest.getPageSize(), (int) count, result));
    }


    private DownloadAddress downloadAddressConvert(DownloadAddressDTO downloadAddressDTO) {
        return DownloadAddress.builder()
                .adress(downloadAddressDTO.getAdress())
                .channel(downloadAddressDTO.getChannel())
                .channelName(downloadAddressDTO.getChannelName())
                .deleted(downloadAddressDTO.getDeleted())
                .descr(downloadAddressDTO.getDescr())
                .device(downloadAddressDTO.getDevice())
                .downloadNums(downloadAddressDTO.getDownloadNums())
                .id(downloadAddressDTO.getId())
                .isForce(downloadAddressDTO.getIsForce())
                .shareAdress(downloadAddressDTO.getShareAdress())
                .version(downloadAddressDTO.getVersion())
                .build();
    }

    private DownloadAddressDTO downloadAddressConvert(DownloadAddress downloadAddress) {
        DownloadAddressDTO downloadAddressDTO = DownloadAddressDTO.builder()
                .adress(downloadAddress.getAdress())
                .channel(downloadAddress.getChannel())
                .channelName(downloadAddress.getChannelName())
                .deleted(downloadAddress.getDeleted())
                .descr(downloadAddress.getDescr())
                .device(downloadAddress.getDevice())
                .downloadNums(downloadAddress.getDownloadNums())
                .id(downloadAddress.getId())
                .isForce(downloadAddress.getIsForce())
                .shareAdress(downloadAddress.getShareAdress())
                .version(downloadAddress.getVersion())
                .build();

        Map<Integer,String> map=new HashMap<>();
        String[] str=downloadAddress.getChannel().split(",");
        for (String s : str) {
            map.put(Integer.valueOf(s), Integer.parseInt(s) == 0 ? "官方" : "渠道" + s);
        }
        downloadAddressDTO.setChannelMap(map);
        return downloadAddressDTO;
    }

}
