package com.live.job.entity.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CrawlQiuShenLiveListDto {
    //正常返回1
    private Integer status;
    //success
    private String system;
    private CrawlQiuShenLiveInfo result;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class CrawlQiuShenLiveInfo{
        private List<CrawlQiuShenLiveInfoCollection> collection;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class CrawlQiuShenLiveInfoCollection{
        private String _id;
        private Schedule schedule;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Schedule {
        private List<Broadcasters> broadcasters;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Broadcasters {
        private Profile profile;
    }

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class Profile {
        private String id;
    }

}
