package com.live.server.controller;

import com.live.common.domain.ResponseData;
import com.live.common.domain.request.ArticleByTagIdRequest;
import com.live.common.domain.request.ArticleSearchRequest;
import com.live.common.domain.request.CommonIntId;
import com.live.common.domain.request.CommonStringId;
import com.live.common.service.ArticleService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@CrossOrigin
@RestController
@RequestMapping("/article")
@Api(tags = "新闻 资讯接口")
public class ArticleController {

    @Resource
    private ArticleService articleService;

    @GetMapping(value = "/getArticleTopTagList")
    @ApiOperation(value = "获取资讯头部标签列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getArticleTopTagList(HttpServletRequest request) {
        return articleService.getArticleTopTagList();
    }

    @GetMapping(value = "/getArticleAllTagList")
    @ApiOperation(value = "获取所有标签列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getArticleAllTagList(HttpServletRequest request) {
        return articleService.getArticleType();
    }

    @GetMapping(value = "/getArticleListByPC")
    @ApiOperation(value = "PC获取首页")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getArticleListByPC(HttpServletRequest request) {
        return articleService.getArticleListByPC(request);
    }

    @GetMapping(value = "/getTopArticleList")
    @ApiOperation(value = "获取资讯首页头部轮播文章")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getTopArticleList(HttpServletRequest request) {
        return articleService.getTopArticleList(request);
    }

    @PostMapping(value = "/getArticleListByTagId")
    @ApiOperation(value = "根据 tagId 获取类型文章列表")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getArticleListByTagId(@RequestBody ArticleByTagIdRequest tagIdRequest, HttpServletRequest request) {
        return articleService.getArticleListByTagId(tagIdRequest, request);
    }

    @PostMapping(value = "/getArticleInfoById")
    @ApiOperation(value = "根据文章 ID 获取文章详情")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    public ResponseData<?> getArticleInfoById(@RequestBody CommonStringId commonStringId, HttpServletRequest request) {
        return articleService.getArticleInfoById(commonStringId, request);
    }

    @PostMapping(value = "/articleSearch")
    @ApiOperation(value = "文章/资讯 搜索")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> articleSearch(@RequestBody ArticleSearchRequest searchRequest, HttpServletRequest request) {
        return articleService.articleSearch(searchRequest, request);
    }

    @PostMapping(value = "/likeArticle")
    @ApiOperation(value = "给文章点赞 / 取消点赞 文章ID")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> likeArticle(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return articleService.likeArticle(commonIntId, request);
    }

    @PostMapping(value = "/collectArticle")
    @ApiOperation(value = "收藏文章")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> collectArticle(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return articleService.collectArticle(commonIntId, 0, request);
    }

    @PostMapping(value = "/cancelCollectArticle")
    @ApiOperation(value = "取消收藏文章")
    @ApiResponses({
            @ApiResponse(code = 200, message = "成功处理请求"),
            @ApiResponse(code = 401, message = "没有权限访问该服务"),
            @ApiResponse(code = 403, message = "权限不足无法访问该服务"),
            @ApiResponse(code = 404, message = "未发现该服务"),
            @ApiResponse(code = 500, message = "服务器内部错误")
    })
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "登录凭证(登录后 token 值)", dataType = "String", paramType = "header", required = true)
    })
    public ResponseData<?> cancelCollectArticle(@RequestBody CommonIntId commonIntId, HttpServletRequest request) {
        return articleService.collectArticle(commonIntId, 1, request);
    }

}
